﻿<%
'------------------------------------------------------------
'
' Microsoft Internet Printing Project
'
' Copyright (c) Microsoft Corporation. All rights reserved.
'
'------------------------------------------------------------
%>

<%

Const L_DerivedFont_Text    = " face=""Tahoma, Verdana, Arial, MS Sans Serif"" "
Const L_DoubleDevFont_Text  = " face=""""Tahoma, Verdana, Arial, MS Sans Serif"""" "

Const PROGID_CLIENT_HELPER  = "OlePrn.PrinterURL"
Const PROGID_SNMP           = "OlePrn.OleSNMP"
Const PROGID_HELPER         = "OlePrn.AspHelp"
Const PROGID_CONVERTER      = "OlePrn.OleCvt"
Const PROGID_ADDPRINTER     = "OlePrn.AddPrint"
Const VIEW_EQUALS           = "&view="
Const ONCLICK_EQUALS        = " onclick="
Const QUOTE                 = """"
Const QUEUE_VIEW            = "ipp_0007.asp"
Const PROPERTY_VIEW         = "ipp_0006.asp"
Const UNAUTHORIZED_401      = "401 Unauthorized"
Const FAXDRIVER             = "Microsoft Shared Fax Driver"
Const V4DRIVER              = "V4 Driver"

Const COMPUTER              = "MS_Computer"
Const LOCAL_SERVER          = "MS_LocalServer"
Const DHTML_ENABLED         = "MS_DHTMLEnabled"
Const DEFAULT_PAGE          = "MS_DefaultPage"
Const PRINTER               = "MS_Printer"
Const URLPRINTER            = "MS_URLPrinter"
Const SNMP                  = "MS_SNMP"
Const IPADDRESS             = "MS_IPAddress"
Const COMMUNITY             = "MS_Community"
Const DEVICE                = "MS_Device"
Const PORTNAME              = "MS_Portname"
Const MODEL                 = "MS_Model"
Const ASP1                  = "MS_ASP1"
Const CONNECT               = "showconnect"
Const ATPRINTER             = "&MS_Printer="
Const ATURLPRINTER          = "&MS_URLPrinter="
Const ATSNMP                = "&MS_SNMP="
Const ATIPADDRESS           = "&MS_IPAddress="
Const ATCOMMUNITY           = "&MS_Community="
Const ATDEVICE              = "&MS_Device="
Const ATPORTNAME            = "&MS_Portname="
Const ATMODEL               = "&MS_Model="
Const ATASP1                = "&MS_ASP1="
Const ATPAGE                = "&page="
Const ATCONNECT             = "&showconnect="

Const IDS_ASP_OPENING                = 400
Const IDS_ASP_GETADSI                = 401
Const IDS_ASP_ACCESSDENIED           = 402
Const IDS_ASP_ALL_PRINTERS           = 403
Const IDS_ASP_NAME                   = 404
Const IDS_ASP_STATUS                 = 405
Const IDS_ASP_LOCATION               = 406
Const IDS_ASP_JOBS                   = 407
Const IDS_ASP_MODEL                  = 408
Const IDS_ASP_COMMENT                = 409
Const IDS_ASP_PREV_PRINTERS          = 410
Const IDS_ASP_NEXT_PRINTERS          = 411
Const IDS_ASP_OPEN_PRINTER           = 412
Const IDS_ASP_PRINTER_READY          = 413
Const IDS_ASP_PRINTER_PAUSED         = 414
Const IDS_ASP_PRINTER_ERROR          = 415
Const IDS_ASP_PRINTER_DELETING       = 416
Const IDS_ASP_PRINTER_JAM            = 417
Const IDS_ASP_PRINTER_OUT_PAPER      = 418
Const IDS_ASP_PRINTER_MANUAL         = 419
Const IDS_ASP_PRINTER_PAPER_PROBLEM  = 420
Const IDS_ASP_PRINTER_OFFLINE        = 421
Const IDS_ASP_PRINTER_IO_ACTIVE      = 422
Const IDS_ASP_PRINTER_BUSY           = 423
Const IDS_ASP_PRINTER_PRINTING       = 424
Const IDS_ASP_PRINTER_BINFULL        = 425
Const IDS_ASP_PRINTER_NOT_AVAILABLE  = 426
Const IDS_ASP_PRINTER_WAITING        = 427
Const IDS_ASP_PRINTER_PROCESSING     = 428
Const IDS_ASP_PRINTER_INITIALIZING   = 429
Const IDS_ASP_PRINTER_WARMING        = 430
Const IDS_ASP_PRINTER_TONER_LOW      = 431
Const IDS_ASP_PRINTER_NO_TONER       = 432
Const IDS_ASP_PRINTER_PAGE_PUNT      = 433
Const IDS_ASP_PRINTER_INTERVENTION   = 434
Const IDS_ASP_PRINTER_OUT_MEMORY     = 435
Const IDS_ASP_PRINTER_DOOR_OPEN      = 436
Const IDS_ASP_PRINTER_STATUS_UNKNOWN = 437
Const IDS_ASP_PRINTER_POWER_SAVE     = 438
Const IDS_ASP_JOB_BYTES              = 439
Const IDS_ASP_JOB_KILO_BYTES         = 440
Const IDS_ASP_JOB_MEGA_BYTES         = 441
Const IDS_ASP_INVALID_ARG            = 442
Const IDS_ASP_ERROR_CODE             = 443
Const IDS_ASP_ERROR_DESCRIPTION      = 444
Const IDS_ASP_ERROR_NOTE             = 445
Const IDS_ASP_ERROR_TITLE            = 446
Const IDS_ASP_ERROR_OCCUR            = 447
Const IDS_ASP_ERROR_PROC             = 448
Const IDS_ASP_AUTH_ERROR             = 449
Const IDS_ASP_AUTH_FAILED            = 450
Const IDS_ASP_AUTH_NO_PRIV           = 451
Const IDS_ASP_CONTACT_NO_PRIV        = 452
Const IDS_ASP_PRINTER_NOT_FOUND      = 453
Const IDS_ASP_QUEUE_STATUS           = 454
Const IDS_ASP_JOB_PAGES              = 455
Const IDS_ASP_LONG_HOUR              = 457
Const IDS_ASP_TEXT_ABOUT             = 458
Const IDS_ASP_ABOUT_HOUR             = 459
Const IDS_ASP_ABOUT_MIN              = 460
Const IDS_ASP_WAIT_TIME              = 461
Const IDS_ASP_TEXT_UNKNOWN           = 462
Const IDS_ASP_JOB_PENDING            = 463
Const IDS_ASP_AVG_SIZE               = 464
Const IDS_ASP_PRINTER_ACTION         = 468
Const IDS_ASP_JOB_ACTION             = 469
Const IDS_ASP_CANCEL_ACTION          = 470
Const IDS_ASP_OPENHELPER_NAME        = 471
Const IDS_ASP_OPENHELPER_Text        = 472
Const IDS_ASP_1_ON_2                 = 473
Const IDS_ASP_FRAME_WARNING          = 474
Const IDS_ASP_CONNECT_FROM           = 475
Const IDS_ASP_DOC_LIST               = 476
Const IDS_ASP_PROPERTY               = 477
Const IDS_ASP_DEVICE_STATUS          = 478
Const IDS_ASP_GO_DOCLIST_PRINTER     = 479
Const IDS_ASP_GO_DOCLIST             = 480
Const IDS_ASP_GO_PROPERTY            = 481
Const IDS_ASP_GO_STATUS              = 482
Const IDS_ASP_SELECT_DOC             = 483
Const IDS_ASP_LIST_ALL_PRINTER       = 484
Const IDS_ASP_ALL_PRINTER            = 485
Const IDS_ASP_PAUSE_PRINTER          = 486
Const IDS_ASP_RESUME_PRINTER         = 487
Const IDS_ASP_CANCEL_DOC             = 488
Const IDS_ASP_CANCEL_ALL_DOC         = 489
Const IDS_ASP_PAUSE_DOC              = 490
Const IDS_ASP_RESUME_DOC             = 491
Const IDS_ASP_DELETE_DOC             = 492
Const IDS_ASP_PAUSE                  = 493
Const IDS_ASP_RESUME                 = 494
Const IDS_ASP_CONNECT                = 495
Const IDS_ASP_DOC_ACTION             = 496
Const IDS_ASP_CANCEL                 = 497
Const IDS_ASP_NAV_BAR                = 498
Const IDS_ASP_PRINTER_ACTION_CAP     = 499
Const IDS_ASP_VIEW_CAP               = 500

Const IDS_ASP_OPEN_PRINTER_2         = 600
Const IDS_ASP_SUPPORTED              = 601
Const IDS_ASP_NOT_SUPPORTED          = 602
Const IDS_ASP_PRINTER_PROP_1_ON_2    = 603
Const IDS_ASP_PRINTER_MODEL          = 604
Const IDS_ASP_LOCATION_2             = 606
Const IDS_ASP_COMMENT_2              = 607
Const IDS_ASP_NET_NAME               = 608
Const IDS_ASP_DOCUMENTS              = 609
Const IDS_ASP_SPEED                  = 610
Const IDS_ASP_DUPLEX                 = 612
Const IDS_ASP_COLOR                  = 613
Const IDS_ASP_RESOLUTION             = 614
Const IDS_ASP_PPM                    = 615
Const IDS_ASP_CPS                    = 616
Const IDS_ASP_LPM                    = 617
Const IDS_ASP_IPM                    = 618
Const IDS_ASP_DPI                    = 619
Const IDS_ASP_OPEN_QUEUE             = 620
Const IDS_ASP_GET_JOBS               = 621
Const IDS_ASP_PAUSED                 = 624
Const IDS_ASP_ERROR                  = 625
Const IDS_ASP_DELETING               = 626
Const IDS_ASP_SPOOLING               = 627
Const IDS_ASP_PRINTING               = 628
Const IDS_ASP_OFFLINE                = 629
Const IDS_ASP_OUT_PAPER              = 630
Const IDS_ASP_PRINTED                = 631
Const IDS_ASP_DELETED                = 632
Const IDS_ASP_BLOCKED                = 633
Const IDS_ASP_INTERVENTION           = 634
Const IDS_ASP_RESTART                = 635
Const IDS_ASP_DOCUMENT               = 636
Const IDS_ASP_OWNER                  = 637
Const IDS_ASP_PAGES                  = 638
Const IDS_ASP_SIZE                   = 639
Const IDS_ASP_SUBMITTED              = 640
Const IDS_ASP_NO_JOB_IN_QUEUE        = 641
Const IDS_ASP_PRE_DOC                = 642
Const IDS_ASP_NEX_DOC                = 643
Const IDS_ASP_PRINTER_INSTALL        = 644
Const IDS_ASP_CHECK_NET              = 645
Const IDS_ASP_VERIFY_LOGIN           = 646
Const IDS_ASP_DOWNLOADING_FILE       = 647
Const IDS_ASP_INSTALL_PRINTER        = 648
Const IDS_ASP_PRINTER_INSTALLED      = 649
Const IDS_ASP_CLICK_OPEN_PFD         = 650
Const IDS_ASP_PRINTER_INSTALL_FAILED = 651
Const IDS_ASP_NOT_CONNECT_SERVER     = 652
Const IDS_ASP_DEVICE_PAGE_ERROR      = 653
Const IDS_ASP_DEVICE_ERROR_DETAIL    = 654
Const IDS_ASP_INET_ERROR             = 655
Const IDS_ASP_DOWNLOAD_DISABLED      = 656
Const IDS_ASP_UNKNOWN_ERROR          = 657
Const IDS_ASP_ERROR_CODE_2           = 658
Const IDS_ASP_TRAY_NOTEMPTY          = 659
Const IDS_ASP_TRAY_EMPTY             = 660

Const IDS_ASP_PAPER_SIZE             = 662
Const IDS_ASP_MEDIA                  = 663
Const IDS_ASP_CURRENT                = 664
Const IDS_ASP_MAX                    = 665
Const IDS_ASP_TRAY                   = 666
Const IDS_ASP_PRINTER                = 667
Const IDS_ASP_OUTPUT                 = 668
Const IDS_ASP_WHITE                  = 669
Const IDS_ASP_ENVELOPE               = 670
Const IDS_ASP_COLORED                = 671
Const IDS_ASP_TRANSP                 = 672
Const IDS_ASP_WHITE_2                = 673
Const IDS_ASP_ENVELOPE_2             = 674
Const IDS_ASP_COLORED_2              = 675
Const IDS_ASP_TRANSP_2               = 676
Const IDS_ASP_WRONG_IP               = 677
Const IDS_ASP_MS_SNMP                = 678
Const IDS_ASP_FRONT_PAN              = 679
Const IDS_ASP_DEVICE_STATUS_2        = 680
Const IDS_ASP_REALTIME               = 682
Const IDS_ASP_CONSOLE_LIGHT          = 683
Const IDS_ASP_DETAILED_ERROR         = 684
Const IDS_ASP_STATUS_2               = 685
Const IDS_ASP_UP_RUNNING             = 686
Const IDS_ASP_FUNC_WARNING           = 687
Const IDS_ASP_BEING_TESTED           = 688
Const IDS_ASP_UNAVAILABLE            = 689
Const IDS_ASP_IDLE                   = 690
Const IDS_ASP_PRINTING_DOC           = 691
Const IDS_ASP_WARMING_UP             = 692
Const IDS_ASP_WARNINGS               = 693
Const IDS_ASP_ERRORS                 = 694
Const IDS_ASP_SERV_REQ               = 695
Const IDS_ASP_PAPER_JAM              = 697
Const IDS_ASP_DOOR_OPEN              = 698
Const IDS_ASP_NO_TONER               = 699
Const IDS_ASP_TOMER_LOW              = 700
Const IDS_ASP_LOW_PAPER              = 702


' when being passed thru URL, a printer name is encoded. For each character, the maximum number of
' characters after encoding is 6. So 512 * 6 = 3072, where we assume the longest printer unc name
' should be less than or equal to 512.
Const MAX_ENCODED_PRINTER_NAME_LENGTH = 3072

Dim   DEF_FONT, DEF_BASEFONT_TAG, DEF_FONT_TAG, LARGE_FONT_TAG, MENU_FONT_TAG
Dim   SUBMENU_FONT, SUBMENU_FONT_TAG, CLIENT_FONT, DEF_DOUBLEFONT, DEF_DOUBLEFONT_TAG

DEF_FONT                    = L_DerivedFont_Text
DEF_DOUBLEFONT              = L_DoubleDevFont_Text
DEF_BASEFONT_TAG            = "<basefont  " & L_DerivedFont_Text & " size=2>"
DEF_FONT_TAG                = "<font " & L_DerivedFont_Text & " size=2>"
LARGE_FONT_TAG              = "<font " & L_DerivedFont_Text & " size=4>"
MENU_FONT_TAG               = "<font " & L_DerivedFont_Text & " size=2 color=white>"
SUBMENU_FONT                = L_DerivedFont_Text & " size=1 "
SUBMENU_FONT_TAG            = "<font " & L_DerivedFont_Text & " size=2>"
CLIENT_FONT                 = "<font " & L_DerivedFont_Text & ">"
Const END_FONT              = "</font>"

Dim OleCvt
Set OleCvt = Server.CreateObject (PROGID_CONVERTER)
Session.Codepage = 65001

Dim L_Language
L_Language = OleCvt.SystemLocale

Dim L_InvalidParameter_Text
L_InvalidParameter_Text = OleCvt.ASPString(IDS_ASP_INVALID_ARG)

Dim L_DocumentList_Text
L_DocumentList_Text = OleCvt.ASPString(IDS_ASP_DOC_LIST)

Function Write (strUnicode)
    Write = strUnicode
End Function

Function SubstituteString(strIn, strPattern, strReplacement)
    Dim iStrPos

    iStrPos = InStr(strIn,strPattern)
    SubstituteString = Left(strIn, iStrPos-1) & strReplacement & Mid(strIn, iStrPos + Len(strPattern))
End Function

Function RepString1( strIn, strRep )
    RepString1 = SubStituteString( strIn, "%1", strRep)
End Function

Function RepString2( strIn, strRep1, strRep2 )
    RepString2 = SubStituteString( RepString1(strIn, strRep1) , "%2", strRep2)
End Function

Function RepString3( strIn, strRep1, strRep2, strRep3 )
    RepString3 = SubStituteString( RepString2(strIn, strRep1, StrRep2), "%3", strRep3)
End Function

Function GenErrorPage (iCode, strSource, strDscp, strNote)
    Dim strHTML

    Dim ErrCode_Text, ErrDscp_Text, ErrNote_Text
    Dim ErrTitle_Text, ErrOccurProc_Text

    ErrCode_Text = OleCvt.ASPString(IDS_ASP_ERROR_CODE)
    ErrDscp_Text = OleCvt.ASPString(IDS_ASP_ERROR_DESCRIPTION)
    ErrNote_Text = OleCvt.ASPString(IDS_ASP_ERROR_NOTE)
    ErrTitle_Text = OleCvt.ASPString(IDS_ASP_ERROR_TITLE)
    ErrOccurProc_Text = OleCvt.ASPString(IDS_ASP_ERROR_PROC)

    strHTML = "<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.0 Transitional//EN"">"
    strHTML = strHTML & "<html lang=" & L_Language & ">"
    strHTML = strHTML & "<head>"
    strHTML = strHTML & "<Meta Http-equiv=""Content-Type"" Content=""text/html; CHARSET=UTF-8"">"
    strHTML = strHTML & "<title>" & ErrTitle_Text & "</title>"
    strHTML = strHTML & "</head><body bgcolor=#FFFFFF>" & DEF_BASEFONT_TAG
    strHTML = strHTML & ErrOccurProc_Text

    If strSource <> "" Then
        strHTML = strHTML & OleCvt.ASPString1(IDS_ASP_ERROR_OCCUR, strSource)
    End If

    strHTML = strHTML & "<table>"

    strHTML = strHTML & "<tr><td>" & ErrCode_Text & "</td><td>" & (Hex (iCode)) & "</td></tr>"

    If strDscp <> "" Then
        strHTML = strHTML & "<tr><td>" & ErrDscp_Text & "</td><td>" & strDscp & "</td></tr>"
    End If

    If strNote <> "" Then
        strHTML = strHTML & "<tr><td>" & ErrNote_Text & "</td><td>" & strNote & "</td></tr>"
    End If

    strHTML = strHTML & "</table></body></html>"
    GenErrorPage = strHTML
End Function

Sub ErrorHandler(strNotes)
    Dim strDscp, strSource

    Dim str401Error

    If Err.Number = 70 Or Err.Number = &H80070005 Then

        Dim L_ErrTitle_Text, L_ErrTitle2_Text
        Dim L_ErrLine1_Text, L_ErrLine2_Text
                
        L_ErrTitle_Text = OleCvt.ASPString(IDS_ASP_AUTH_ERROR)
        L_ErrTitle2_Text = OleCvt.ASPString(IDS_ASP_AUTH_FAILED)
        L_ErrLine1_Text = OleCvt.ASPString(IDS_ASP_AUTH_NO_PRIV)
        L_ErrLine2_Text = OleCvt.ASPString(IDS_ASP_CONTACT_NO_PRIV)


        str401Error = "<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.0 Transitional//EN"">" &_
            "<html lang=" & L_Language & ">" &_
            "<head>" &_
            "<Meta Http-equiv=""Content-Type"" Content=""text/html; CHARSET=UTF-8"">" &_
            "<title>" & L_ErrTitle_Text & "</title>" & "</head>" &_
            "<body bgcolor=#FFFFFF>" &_
            DEF_FONT_TAG &_
            "<p><H2>" & L_ErrTitle2_Text & "</H2></p>" &_
            "<p>" & L_ErrLine1_Text &_
            "<br>" &_
            "<br>" & L_ErrLine2_Text & "</p>" &_
            "</font></body></html>"
        response.write (Write(str401Error))
        response.status = UNAUTHORIZED_401
    Else
        If Err.Number = &H80070709 Then
            Err.Description = OleCvt.ASPString(IDS_ASP_PRINTER_NOT_FOUND)
        End If

        response.write(Write(GenErrorPage (Err.Number, Err.Source, Err.Description, strCleanString(strNotes))))
    End If
    response.Expires = 0
    response.end

End Sub

Function bDHTMLSupported()
    On Error Resume Next
    Err.Clear
    Dim objBrowcap

    Set objBrowcap = server.CreateObject("MSWC.browsertype")
    If Not Err And objBrowcap.browser = "IE" And objBrowcap.majorver >= "4" Then
        bDHTMLSupported = True
    Else
        bDHTMLSupported = False
    End If
End Function

Sub CheckSession()
    ' check to see if the session has timed out
    If Session(COMPUTER) = "" Then
        response.redirect ("ipp_0003.asp")
        response.end
    End If
End Sub

Function strPrinterStatus(iStatus)
    Dim L_PrinterStatus_Text(24)
    Const L_Seperator_Text = " - "

    Dim L_PrinterReady_Text
    L_PrinterReady_Text = OleCvt.ASPString(IDS_ASP_PRINTER_READY)

    L_PrinterStatus_Text(0)  = OleCvt.ASPString(IDS_ASP_PRINTER_PAUSED)
    L_PrinterStatus_Text(1)  = OleCvt.ASPString(IDS_ASP_PRINTER_ERROR)
    L_PrinterStatus_Text(2)  = OleCvt.ASPString(IDS_ASP_PRINTER_DELETING)
    L_PrinterStatus_Text(3)  = OleCvt.ASPString(IDS_ASP_PRINTER_JAM)
    L_PrinterStatus_Text(4)  = OleCvt.ASPString(IDS_ASP_PRINTER_OUT_PAPER)
    L_PrinterStatus_Text(5)  = OleCvt.ASPString(IDS_ASP_PRINTER_MANUAL)
    L_PrinterStatus_Text(6)  = OleCvt.ASPString(IDS_ASP_PRINTER_PAPER_PROBLEM)
    L_PrinterStatus_Text(7)  = OleCvt.ASPString(IDS_ASP_PRINTER_OFFLINE)
    L_PrinterStatus_Text(8)  = OleCvt.ASPString(IDS_ASP_PRINTER_IO_ACTIVE)
    L_PrinterStatus_Text(9)  = OleCvt.ASPString(IDS_ASP_PRINTER_BUSY)
    L_PrinterStatus_Text(10) = OleCvt.ASPString(IDS_ASP_PRINTER_PRINTING)
    L_PrinterStatus_Text(11) = OleCvt.ASPString(IDS_ASP_PRINTER_BINFULL)
    L_PrinterStatus_Text(12) = OleCvt.ASPString(IDS_ASP_PRINTER_NOT_AVAILABLE)
    L_PrinterStatus_Text(13) = OleCvt.ASPString(IDS_ASP_PRINTER_WAITING)
    L_PrinterStatus_Text(14) = OleCvt.ASPString(IDS_ASP_PRINTER_PROCESSING)
    L_PrinterStatus_Text(15) = OleCvt.ASPString(IDS_ASP_PRINTER_INITIALIZING)
    L_PrinterStatus_Text(16) = OleCvt.ASPString(IDS_ASP_PRINTER_WARMING)
    L_PrinterStatus_Text(17) = OleCvt.ASPString(IDS_ASP_PRINTER_TONER_LOW)
    L_PrinterStatus_Text(18) = OleCvt.ASPString(IDS_ASP_PRINTER_NO_TONER)
    L_PrinterStatus_Text(19) = OleCvt.ASPString(IDS_ASP_PRINTER_PAGE_PUNT)
    L_PrinterStatus_Text(20) = OleCvt.ASPString(IDS_ASP_PRINTER_INTERVENTION)
    L_PrinterStatus_Text(21) = OleCvt.ASPString(IDS_ASP_PRINTER_OUT_MEMORY)
    L_PrinterStatus_Text(22) = OleCvt.ASPString(IDS_ASP_PRINTER_DOOR_OPEN)
    L_PrinterStatus_Text(23) = OleCvt.ASPString(IDS_ASP_PRINTER_STATUS_UNKNOWN)
    L_PrinterStatus_Text(24) = OleCvt.ASPString(IDS_ASP_PRINTER_POWER_SAVE)

    Dim bit, i
    bit = 1
    i = 0
    Dim strHTML, bFirst

    bFirst = True
    strHTML = ""

    For i = 0 To 24
    If iStatus And bit Then
        If Not bFirst Then
        strHTML = strHTML + L_Seperator_Text
        End If
        strHTML = strHTML + L_PrinterStatus_Text(i)
            bFirst = False
    End If
        bit = bit * 2
    Next
    If bFirst Then
        strHTML = "<font color=green>" & L_PrinterReady_Text & "</font>"
    Else
        strHTML = "<font color=red>" & strHTML & "</font>"
    End If

    strPrinterStatus = strHTML
End Function

Function strFormatJobSize(iJobSize)

    If iJobSize < 1024 Then
        strFormatJobSize = OleCvt.ASPString1( IDS_ASP_JOB_BYTES, CStr(iJobSize) )
    ElseIf iJobSize < 1048576 Then
        strFormatJobSize = OleCvt.ASPString1( IDS_ASP_JOB_KILO_BYTES, formatnumber(iJobSize / 1024, 1) )
    Else
        strFormatJobSize = OleCvt.ASPString1( IDS_ASP_JOB_MEGA_BYTES, formatnumber(iJobSize / (1024 * 1024), 1) )
    End If
        
End Function

Function strFormatString(str)
    If str = "" Then
        strFormatString = "&nbsp;"
    Else
        strFormatString = str
    End If
End Function

Function strCleanString (str)

    Dim strClean, i, iLength, ch

    ' Null strings get treated as empty strings
    If IsNull(str) Then
        str = ""        
    End If

    strClean = ""
    iLength = Len (str)

    For i = 1 To iLength
        ch = Mid (str, i, 1)

        Select Case ch
        Case "<"
            strClean = strClean & "&lt;"
        Case ">"
            strClean = strClean & "&gt;"
        Case """"
            strClean = strClean & "&quot;"
        Case "&"
            strClean = strClean & "&amp;"
        Case Else
            strClean = strClean & ch
        End Select
    Next
    strCleanString = strClean

End Function

Function strCleanRequest (str)

    strCleanRequest = strCleanString (Request(str))

End Function

Function JobEtaInfo (objPrinter)
    Dim strTime, iJobCount, iMinute
    Dim strHTML

    Dim L_WaitingTime_Text, L_AvgSize_Text
    L_WaitingTime_Text = " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>" & OleCvt.ASPString(IDS_ASP_WAIT_TIME) & "</b> "
    L_AvgSize_Text = " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>" & OleCvt.ASPString(IDS_ASP_AVG_SIZE) & "</b> "

    strHTML = OleCvt.ASPString1(IDS_ASP_QUEUE_STATUS, strPrinterStatus (objPrinter.Status))
    strHTML = strHTML & L_WaitingTime_Text

    objPrinter.CalcJobETA

    If ( objPrinter.Status And &H9F ) Then
        strHTML = strHTML & OleCvt.ASPString(IDS_ASP_TEXT_UNKNOWN)
    Else
        If objPrinter.PendingJobCount = 0 Then
            strHTML = strHTML & "0"
        Else
            iMinute = objPrinter.JobCompletionMinute
            'iMinute = 240  'For testing purpose
            If iMinute <> -1 Then
                If iMinute > 480 Then
                    strTime = OleCvt.ASPString(IDS_ASP_LONG_HOUR)
                Elseif iMinute > 60 Then
                    strTime = OleCvt.ASPString1(IDS_ASP_ABOUT_HOUR, CStr(Int (iMinute / 60)))
                Else
                    strTime = OleCvt.ASPString1(IDS_ASP_ABOUT_MIN, CStr(iMinute))
                End If
                strHTML = strHTML & strTime
            Else
                strHTML = strHTML & OleCvt.ASPString(IDS_ASP_TEXT_UNKNOWN)
            End If
        End If
    End If

    strHTML = strHTML & "<br>"
    iJobCount = objPrinter.PendingJobCount
    strHTML = strHTML & OleCvt.ASPString1(IDS_ASP_JOB_PENDING, CStr(iJobCount))

    If iJobCount > 0 Then
        strHTML = strHTML & L_AvgSize_Text
        If ObjPrinter.AvgJobSizeUnit = 1 Then 'Page
            strHTML = strHTML & OleCvt.ASPString1(IDS_ASP_JOB_PAGES, CStr(ObjPrinter.AvgJobSize))
        Else
            strHTML = strHTML & strFormatJobSize(ObjPrinter.AvgJobSize)
        End If
    End If


    JobEtaInfo = "<font " & DEF_FONT & "size= -1>" & strHTML & "</font>"

End Function

Function GetFriendlyName (strPrtName, strComputer)

    Dim lOffset, strServerName

    If Left (strPrtName, 2) = "\\" Then
        lOffset = InStr (3, strPrtName, "\")
        strServerName = Mid (strPrtName, 3, lOffset - 3)
        If strServerName = strComputer Then 'Cut the server name only if it is same as the computer name
            strPrtName = Mid (strPrtName, lOffset + 1)
        End If
    End If
    GetFriendlyName = strPrtName

End Function

Function GetServerNameFixedForIPv6
    Dim strServer

    strServer = request.ServerVariables("SERVER_NAME")

    '
    ' The SERVER_NAME variable does not wrap IPv6 addresses in
    ' [] so we do that here if we detect IPv6.
    '
    ' IPv6 is detected by looking for at least 1 colon (':').  An IPv6
    ' address must contain 1 colon and DNS, NetBIOS, and IPv4 cannot
    ' contain colons.
    '
    If (InStr(1, strServer, ":", 1) > 0) Then
        strServer = "[" + strServer + "]"
    End If

    GetServerNameFixedForIPv6 = strServer
End Function

%>
