﻿<%@ CODEPAGE=65001 %> 
<%
'------------------------------------------------------------
'
' Microsoft Internet Printing Project
'
' Copyright (c) Microsoft Corporation. All rights reserved.
'
'------------------------------------------------------------
    option explicit

%>
<!-- #include file = "ipp_util.inc" -->
<% 	
    CheckSession
    Response.Expires = 0

    Dim strPrinter, strComputer, objQueue, objJobs, strAction, iRes
    Dim objPrinter

    On Error Resume Next
    Err.Clear

    strPrinter = Request("eprinter")
    if Len(strPrinter) > MAX_ENCODED_PRINTER_NAME_LENGTH Then
        Call ErrorHandler(L_InvalidParameter_Text)
    Else
        strPrinter = OleCvt.DecodeUnicodeName(strPrinter)
    End If

    strComputer = Session(COMPUTER)
    Set objQueue = GetObject("WinNT://" & strComputer & "/" & strPrinter & ",PrintQueue")
    Set objJobs = objQueue.PrintJobs

    Set objPrinter = Server.CreateObject(PROGID_HELPER)
    objPrinter.open "\\" & strComputer & "\" & strPrinter
    If Err Then
        Call ErrorHandler (OleCvt.ASPString(IDS_ASP_OPEN_PRINTER_2))
    End If

Function isSupported(bSupported)
    If bSupported = 1 Then
        isSupported = OleCvt.ASPString(IDS_ASP_SUPPORTED)
    Else
        isSupported = OleCvt.ASPString(IDS_ASP_NOT_SUPPORTED)
    End If
End Function

    Dim strTitle
    strTitle = "<title>" & OleCvt.ASPString2(IDS_ASP_PRINTER_PROP_1_ON_2, strCleanString(strPrinter), session(LOCAL_SERVER)) & "</title>"

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html lang=<%=L_Language%>>
<head>
<Meta Http-equiv="Content-Type" Content="text/html; CHARSET=UTF-8">
<meta http-equiv="refresh" content="30">
<% =Write (strTitle) %>
</head>


<%
Function GetString (str)

    If str = "" Then
        GetString = "&nbsp;"
    Else
        GetString = strCleanString (str)
    End If
End Function

Function GenPropertyTable (objQueue, objPrinter)
    Dim strHTML
    Dim strBgnCol1, strBgnCol2, strEndCol
    Dim strBgnRow, strEndRow
    Dim strTmp, strUnit
    Dim strUrl
    Dim i, arrayNameList, iUnit

    strHTML = ""

    strBgnCol1 = "<tr><td width=""138"" valign=""top"">" & DEF_FONT_TAG & "<b>"
    strBgnCol2 = "</b>" & END_FONT & "</td><td>" & DEF_FONT_TAG
    strEndCol  = END_FONT & "</td></tr>"

    strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_PRINTER_MODEL) & strBgnCol2 & GetString(objQueue.model) & strEndCol
    strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_LOCATION_2) & strBgnCol2 & _
              GetString (objQueue.Location) & strEndCol 
    strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_COMMENT_2) & strBgnCol2 & _
              GetString (objQueue.Description) & strEndCol 

    If Request.ServerVariables("HTTPS") = "off" Then
        strUrl = "http://"
    Else
        strUrl = "https://"
    End If

    strUrl = GetString(strUrl & session(LOCAL_SERVER) & "/printers/" & GetFriendlyName (objQueue.Printerpath, strComputer) & "/.printer")

    strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_NET_NAME) & strBgnCol2 & strUrl & strEndCol 
    strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_DOCUMENTS) & strBgnCol2 & objQueue.JobCount & strEndCol

    On Error Resume Next
    Err.Clear

    iUnit = objPrinter.PageRateUnit
    If Err.Number = 0 Then
        strTmp = objPrinter.PageRate
        If Err.Number = 0 And strTmp <> "0" Then
        
            Select Case iUnit
            Case 1
                strUnit = OleCvt.ASPString(IDS_ASP_PPM)
            Case 2
                strUnit = OleCvt.ASPString(IDS_ASP_CPS)
            Case 3
                strUnit = OleCvt.ASPString(IDS_ASP_LPM)
            Case 4
                strUnit = OleCvt.ASPString(IDS_ASP_IPM)
            End Select

            strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_SPEED) & "" & strBgnCol2 & strTmp & strUnit & strEndCol
        End If
    End If
    Err.Clear

    strTmp = objPrinter.Color
    If Err.Number = 0 Then
        strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_COLOR) & strBgnCol2 & isSupported (strTmp) & strEndCol
    End If
    Err.Clear


    strTmp = objPrinter.Duplex
    If Err.Number = 0 Then
        strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_DUPLEX) & strBgnCol2 & isSupported (strTmp) & strEndCol 
    End If
    Err.Clear

    strTmp = objPrinter.MaximumResolution
    If Err.Number = 0 Then
        strHTML = strHTML & strBgnCol1 & OleCvt.ASPString(IDS_ASP_RESOLUTION) & strBgnCol2 & strTmp & OleCvt.ASPString(IDS_ASP_DPI) & strEndCol 
    End If

    GenPropertyTable = strHTML

End Function
%>

<body bgcolor="#FFFFFF" text="#000000" link="#000000" vlink="#000000" alink="#000000"
topmargin="0" leftmargin="0">

<table border="0" cellpadding="2" cellspacing="0" width="100%">
<%=Write (GenPropertyTable (objQueue, objPrinter))%>
</table>

<%
    objPrinter.close
%>

</body>
</html>
