﻿<%
'------------------------------------------------------------
'
' Microsoft Internet Printing Project
'
' Copyright (c) Microsoft Corporation. All rights reserved.
'
'------------------------------------------------------------
Const SNMP_ALERT_SEVERITY       = 0
Const SNMP_ALERT_INDEX          = 1
Const SNMP_ALERT_SUBUNIT        = 2
Const SNMP_ALERT_DESCRIPTION    = 3
Const SNMP_ALERT_CODE           = 4
Const SNMP_ALERT_TRAINING       = 5
Const SNMP_ALERT_ATTRIBUTES     = 5
Const SNMP_INTRAY_TYPE          = 0
Const SNMP_INTRAY_UNITS         = 1
Const SNMP_INTRAY_MAX           = 2
Const SNMP_INTRAY_CURRENT       = 3
Const SNMP_INTRAY_STATE         = 4
Const SNMP_INTRAY_MEDIA         = 5
Const SNMP_INTRAY_UNIT          = 6
Const SNMP_INTRAY_NAME          = 7
Const SNMP_INTRAY_ATTRIBUTES    = 7
Const SNMP_LIGHT_ON             = 0
Const SNMP_LIGHT_OFF            = 1
Const SNMP_LIGHT_COLOR          = 2
Const SNMP_LIGHT_DESCRIPTION    = 3
Const SNMP_LIGHT_ATTRIBUTES     = 3

Function rgSNMPGetState(objSNMP, iDevice)
    Dim rgFetchList, rgState, StrDevice, rgFetchValue, hrPrintDetectedState

    On Error Resume Next
    Err.Clear
    StrDevice = CStr(iDevice)
    rgFetchList = Array("25.3.2.1.5." & StrDevice, "25.3.5.1.1." & StrDevice)

    hrPrintDetectedState = objSNMP.GetAsByte ("25.3.5.1.2." & StrDevice)
    If Err Then Exit Function

    rgFetchValue = objSNMP.GetList(rgFetchList)
    If Err Then Exit Function

    rgState = Array (rgFetchValue(0), rgFetchValue(1), hrPrintDetectedState)
    If Err Then Exit Function

    rgSNMPGetState = rgState
End Function

Function GetLastNode (strMib)
    Dim strTmp, j

    For j = 1 To Len (strMib)
        strTmp = Right (strMib, j)
        If Left (strTmp, 1) = "." Then
            GetLastNode = strTmp
            Exit Function
        End If
    Next
    GetLastNode = ""
End Function

Function rgSNMPGetAlerts(objSNMP, objHelper, iDevice, iAlerts)
    Dim rgTmp, rgAlerts()
    Dim i, StrDevice

    On Error Resume Next

    iAlerts = -1
    StrDevice = CStr(iDevice)
    rgTmp = objSNMP.GetTree("43.18.1.1.2." & StrDevice) 'alert severities
    If Err Then 'assume there is not alert table
        Err.Clear
        Exit Function
    End If

    If UBound(rgTmp, 2) >= 0 Then
        iAlerts = UBound(rgTmp, 2)

        ReDim rgAlerts(SNMP_ALERT_ATTRIBUTES, iAlerts)

        For i = 0 to iAlerts
            rgAlerts(SNMP_ALERT_INDEX, i) = i
            rgAlerts(SNMP_ALERT_SEVERITY, i) = rgTmp(1, i)
        Next

        'rgTmp = objSNMP.GetTree("43.18.1.1.3." & StrDevice)

        'If UBound(rgTmp,2)  = iAlerts Then
        '    For i = 0 to iAlerts
        '        rgAlerts(SNMP_ALERT_TRAINING, i) = rgTmp(1, i)
        '    Next
        'End If

        rgTmp = objSNMP.GetTree("43.18.1.1.4." & StrDevice)

        If UBound(rgTmp,2)  = iAlerts Then
            For i = 0 to iAlerts
                rgAlerts(SNMP_ALERT_SUBUNIT, i) = rgTmp(1, i)
            Next
        End If

        rgTmp = objSNMP.GetTree("43.18.1.1.5." & StrDevice)

        If UBound(rgTmp,2)  = iAlerts Then
            For i = 0 to iAlerts
                rgAlerts(SNMP_ALERT_INDEX, i) = rgTmp(1, i)
            Next
        End If

        rgTmp = objSNMP.GetTree("43.18.1.1.7." & StrDevice)

        If UBound(rgTmp,2)  = iAlerts Then
            For i = 0 to iAlerts
                rgAlerts(SNMP_ALERT_CODE, i) = rgTmp(1, i)
            Next

            For i = 0 to iAlerts
                If rgTmp(1,i) = 1 Then 'Other Error
                    rgAlerts(SNMP_ALERT_DESCRIPTION, i) = objSNMP.Get ("43.18.1.1.8." & StrDevice & GetLastNode (rgTmp (0, i)))
                    If rgAlerts(SNMP_ALERT_DESCRIPTION, i) = "" Then
                        rgAlerts(SNMP_ALERT_DESCRIPTION, i) = objHelper.MibErrorDscp (rgTmp(1, i))
                    End If
                Else
                    rgAlerts(SNMP_ALERT_DESCRIPTION, i) = objHelper.MibErrorDscp (rgTmp(1, i))
                    If rgAlerts(SNMP_ALERT_DESCRIPTION, i) = "" Then
                        rgAlerts(SNMP_ALERT_DESCRIPTION, i) = objSNMP.Get ("43.18.1.1.8." & StrDevice & GetLastNode (rgTmp (0, i)))
                    End If
                End If
            Next

        End If

        rgSNMPGetAlerts = rgAlerts
    End If
End Function

Function rgSNMPGetInputTrays(objSNMP, iDevice, iTrays)
    Dim rgWork, iFetch, StrDevice, i, rgTrays()
    Dim j
    Dim rgFetchOid(7)

    On Error Resume Next
    Err.Clear

    StrDevice = CStr(iDevice)
    rgFetchOid(0) = "43.8.2.1.2." & StrDevice      'type
    rgFetchOid(1) = "43.8.2.1.8." & StrDevice      'units
    rgFetchOid(2) = "43.8.2.1.9." & StrDevice      'max
    rgFetchOid(3) = "43.8.2.1.10." & StrDevice     'current
    rgFetchOid(4) = "43.8.2.1.11." & StrDevice     'state
    rgFetchOid(5) = "43.8.2.1.12." & StrDevice     'media
    rgFetchOid(6) = "43.8.2.1.13." & StrDevice     'input unit
    rgFetchOid(7) = "43.8.2.1.18." & StrDevice     'trayname



    rgWork = objSNMP.GetTree(rgFetchOid(0))
    If Err Then Exit Function
    iTrays = UBound(rgWork, 2)


    If iTrays >= 0 Then
        ReDim rgTrays(SNMP_INTRAY_ATTRIBUTES, iTrays)

        For j = 0 To 7
            If j <> 0 Then
                rgWork = objSNMP.GetTree(rgFetchOid(j))
                If Err Then Exit Function
            End If

            For i = 0 To UBound(rgWork, 2)
                rgTrays(j, i) = rgWork(1, i)
            Next
        Next

        rgSNMPGetInputTrays = rgTrays

    End If
End Function

Function strAppendStr (strBody, strTail)
    Dim L_Comma_Text

    L_Comma_Text = ", "

    If strBody = "" Then
        strAppendStr = strTail
    Else
        strAppendStr = strBody & L_Comma_Text & strTail
    End If
End Function

Function rgSNMPConsole(objSNMP, iDevice, iRow, iColumn, rgConText, strLang)

Const prtConsoleLocalization = "43.5.1.1.10."
Const prtConsoleNumberOfDisplayLines = "43.5.1.1.11."
Const prtConsoleNumberOfDisplayChars = "43.5.1.1.12."
Const prtConsoleDisplayBufferText = "43.16.5.1.2."
Const prtLocalizationLanguage = "43.7.1.1.3."

    Dim StrDevice, i, rgOidList, rgConsole

    StrDevice = CStr(iDevice)
    rgSNMPConsole = False
    rgConText = ""

    rgOidList = Array(prtConsoleLocalization & StrDevice, prtConsoleNumberOfDisplayLines & StrDevice, prtConsoleNumberOfDisplayChars & StrDevice)
    rgConsole = objSNMP.GetList(rgOidList)
    If Err.Number <> 0 Then Exit Function

    iRow = rgConsole(1)
    iColumn = rgConsole(2)

    if iRow <> 0 Then

        ReDim rgConTextOidList(iRow - 1)
        For i = 0 To iRow - 1
            rgConTextOidList(i) = prtConsoleDisplayBufferText & StrDevice & "." & CStr(i + 1)
        Next

        rgConText = objSNMP.GetList(rgConTextOidList)
        If Err.Number <> 0 Then Exit Function

        strLang = objSNMP.Get (prtLocalizationLanguage & StrDevice & "." & rgConsole(0))
        If Err.Number <> 0 Then Exit Function
    End If

    rgSNMPConsole = True

End Function


Function rgSNMPLights(objSNMP, iDevice, iLights)
    Dim rgWork
    Dim rgFetchOid(4)
    Dim StrDevice

    StrDevice = CStr(iDevice)
	
    On Error Resume Next
    rgFetchOid(0) = "43.17.6.1.2." & StrDevice & "."
    rgFetchOid(1) = "43.17.6.1.3." & StrDevice & "."
    rgFetchOid(2) = "43.17.6.1.4." & StrDevice & "."
    rgFetchOid(3) = "43.17.6.1.5." & StrDevice & "."

    rgWork = objSNMP.GetTree(rgFetchOid(0))
    If Err Then Exit Function

    iLights = UBound(rgWork, 2)

    If iLights >= 0 Then
        Dim i, j
        ReDim rgLights(SNMP_LIGHT_ATTRIBUTES, iLights)

        For j = 0 To 3
            If j <> 0 Then
                rgWork = objSNMP.GetTree(rgFetchOid(j))
                If Err Then Exit Function
            End If

            For i = 0 To UBound(rgWork, 2)
                rgLights(j, i) = rgWork(1, i)
            Next
        Next

        rgSNMPLights = rgLights

    End If

End Function
%>
